unit fpcedit1;
//********************************************************************
//  Created by KOL project Expert Version 2.03 on:22-5-2005 10:27:39
//********************************************************************

{.$DEFINE TEST_DESTROY}
interface
uses
  Windows, Messages, Kol, richedit;

type

PForm1=^TForm1;
TForm1=object(Tobj)
  Edit,
  Pnl,
  Toolbar,
  Form:pControl;
  Menu:PMenu;
  Dlg:POpensavedialog;
public
  procedure DoMenu(Sender:PMenu;index:integer);
  procedure DoToolbar(sender:Pobj);
  procedure EditChange(sender:PObj);
  procedure FormClose( Sender: PObj; var Accept: Boolean );
  function CheckModified:integer;
{$IFDEF TEST_DESTROY}
  procedure Destroying(sender:PObj);
{$ENDIF}
  procedure UpdateControls;
  procedure Save;
  procedure Load;
end;


procedure NewForm1( var Result: PForm1; AParent: PControl );
var
  Form1:pForm1;

implementation

procedure NewForm1( var Result: PForm1; AParent: PControl );
{$IFDEF TEST_DESTROY}
var
  i:integer;
{$ENDIF}
begin
  New(Result,Create);
  with Result^ do
  begin
    Applet:=Newapplet('FPC KOL Example editor');
    Form:= NewForm(Applet,'KOL Freepascal 2.00 Notepad').SetSize(600,400).centeronparent.Tabulate;
    Form.Add2AutoFree(Result);
    Form.OnClose:=FormClose;
    form.font.releasehandle;
    form.font.assignhandle(getstockobject(default_gui_font));
    Menu:=Newmenu(form,0,['&File','(','&New','-','&Open','&save','Save &As','-','E&xit',')',
      '&Edit','(','&Undo','&Redo','-','Cu&t','&Copy','&Paste',')',
      '&Help','(','&About',')',''],DoMenu);
    Pnl:=Newpanel(form,esNone).setalign(caTop);
    Toolbar:=NewToolbar(pnl,caTop,[tboFlat],HBITMAP(-1),[Pchar(' '),Pchar(' '),
          Pchar(' '),Pchar(' '),Pchar(' '),Pchar(' '),Pchar(' '),Pchar(' ')],[6,7,8,3,4,0,1,2]).resizeparent;
    Toolbar.Onclick:=DoToolbar;
    Form.simplestatustext:='';
    Edit:=NewrichEdit(form,[eoMultiline,eoNoHscroll]).setalign(caClient);
    Edit.OnChange:=EditChange;
    dlg:=NewopensaveDialog('','',[]);
    dlg.Filter:='Text Files|*.txt;*.me;*.cfg|Rich Text Files|*.rtf|All Files|*.*';
    Edit.Add('Welcome to the FPC editor written in KOL');
    UpdateControls;
{$IFDEF TEST_DESTROY}
    Pnl.OnDestroy:=Destroying;
    Menu.Ondestroy:=Destroying;
    Toolbar.Ondestroy:=Destroying;
    for i:=0 to form.childcount-1 do
      form.Children[i].Ondestroy:=Destroying;
{$ENDIF}
    SetProcessWorkingSetSize(GetCurrentProcess,Cardinal(-1),Cardinal(-1));
  end;
end;



{ TForm1 }

procedure TForm1.DoMenu(Sender: PMenu; index: integer);
var
  Check:Integer;
begin
  case index of
  1: begin
       dlg.OpenDialog:=False;
       Check:=CheckModified;
       if Check = ID_CANCEL then exit else
         if Check = ID_YES then
           if dlg.execute then Save
             else
               exit;
       edit.clear;
       dlg.Filename:='';
       edit.perform(EM_SETMODIFY,0,0);
     end;
  3: begin
       dlg.OpenDialog:=False;
       Check:=CheckModified;
       if Check = ID_CANCEL then exit else
         if Check = ID_YES then
           if dlg.execute then save
             else
               exit;
       dlg.OpenDialog:=true;
       if dlg.execute then load;
     end;
  4: begin
       dlg.OpenDialog:=False;
       if dlg.execute then save;
     end;
  7: begin
       Check:=CheckModified;
       if Check = ID_CANCEL then exit else
       if Check = ID_OK then Save;
       Applet.close;
     end;
  9: Edit.perform(EM_UNDO,0,0);
  10:Edit.Perform(EM_REDO,0,0);
  12:Edit.Perform(WM_CUT,0,0);
  13:Edit.Perform(WM_COPY,0,0);
  14:Edit.Perform(WM_PASTE,0,0);
  else
   MsgOk(int2str(index));
  end;
  form.simplestatustext:=Pchar(dlg.filename);
  UpdateControls;
  SetProcessWorkingSetSize(GetCurrentProcess,Cardinal(-1),Cardinal(-1));
end;

procedure TForm1.DoToolbar(sender: Pobj);
begin
  case toolbar.curindex of
  0:Domenu(menu,1);
  1:DoMenu(menu,3);
  2:Domenu(menu,4);
  3:DoMenu(menu,9);
  4:DoMenu(menu,10);
  5:Domenu(Menu,12);
  6:DoMenu(Menu,13);
  7:DoMenu(Menu,14);
  else
  msgOk(int2str(Toolbar.Curindex));
  end;
  UpdateControls;
end;

procedure TForm1.UpdateControls;
begin
    Menu.ItemEnabled[9]:=Boolean(Edit.Perform(EM_CANUNDO ,0,0));
    Menu.ItemEnabled[10]:=Boolean(Edit.Perform(EM_CANREDO ,0,0));
    Menu.ItemEnabled[12]:=Boolean(Edit.sellength);
    Menu.ItemEnabled[13]:=Boolean(Edit.sellength);
    Menu.ItemEnabled[14]:=Boolean(Edit.Perform(EM_CANPASTE,0,0));
    Toolbar.TbButtonEnAbled[3]:=Menu.ItemEnAbled[9];
    Toolbar.TbButtonEnAbled[4]:=Menu.ItemEnAbled[10];
    Toolbar.TbButtonEnAbled[5]:=Menu.ItemEnAbled[12];
    Toolbar.TbButtonEnAbled[6]:=Menu.ItemEnAbled[13];
    Toolbar.TbButtonEnAbled[7]:=Menu.ItemEnAbled[14];
end;

procedure TForm1.Load;
begin
  case dlg.filterindex of
  1,
  3: Edit.re_LoadFromFile(dlg.Filename,reText,False);
  2: Edit.re_LoadFromFile(dlg.Filename,reRtf,False);
  end;
  edit.perform(EM_SETMODIFY,0,0);
end;

procedure TForm1.Save;
begin
  case dlg.filterindex of
  1,
  3: Edit.re_SaveToFile(dlg.Filename,reText,false);
  2: Edit.re_SaveToFile(dlg.filename,reRtf,false);
  end;
  edit.perform(EM_SETMODIFY,0,0);
end;


procedure TForm1.EditChange(sender: PObj);
begin
  UpdateControls;
end;

function TForm1.CheckModified: integer;
begin
  if Edit.Perform(EM_GETMODIFY,0,0) <> 0 then
    result:= MessageBox(0,'Do you want to save the changes?','File has changed',
      MB_YESNOCANCEL or MB_ICONINFORMATION)
    else
     result:=ID_NO;
end;

procedure TForm1.FormClose(Sender: PObj; var Accept: Boolean);
var
  Check:integer;
begin
  Accept:=true;
  Check:= CheckModified;
  if Check = ID_CANCEL then accept:=false else
    if Check = ID_YES then
      if dlg.execute then Save;
end;

{$IFDEF TEST_DESTROY}
procedure TForm1.Destroying(sender: PObj);
begin
  MsgOk('Destroying '+Pcontrol(sender).subclassname);
end;
{$ENDIF}

end.